<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Farmadati Data Fetcher</title>
</head>
<body>
    <h1>Fetch Data from Farmadati Tables</h1>
    <form action="" method="post">
        <button type="submit" name="fetch_all_tables">Fetch Data from All Tables</button>
    </form>

    <?php
    if (isset($_POST['fetch_all_tables'])) {
        $username = 'BDF20867412';
        $password = 'jwAD4gey7';
        $wsdl = 'https://webservices.farmadati.it/WS2S/FarmadatiItaliaWebServicesM1.svc?singleWsdl';
        $tables = [
            'TE001', 'TE002', 'TE004', 'TE005', 'TE006', 'TE008', 'TE009', 
            'TE010', 'TE011', 'TE012', 'TE015', 'TE016', 'TE018', 'TR011', 
            'TR036', 'TR037', 'TR039', 'TR048', 'TS010', 'TS011', 'TS042', 
            'TS043', 'TS049', 'TS054', 'TS067', 'TS077'
        ];
        
        foreach ($tables as $table_code) {
            try {
                $client = new SoapClient($wsdl, array('trace' => 1));
                $params = array(
                    'Username' => $username,
                    'Password' => $password,
                    'CodiceSetDati' => $table_code,
                    'CampiDaEstrarre' => array('string' => 'ALL'),
                    'Filtri' => null,
                    'Ordinamento' => null,
                    'Distinct' => false,
                    'Count' => false,
                    'PageN' => 1,
                    'PagingN' => 3
                );
                $response = $client->__soapCall('ExecuteQuery', array('parameters' => $params));

                $outputValue = $response->ExecuteQueryResult->OutputValue;
                $xml = simplexml_load_string($outputValue);
                if ($xml === false) {
                    echo '<h2>Error parsing XML for table ' . htmlspecialchars($table_code) . '</h2>';
                    foreach (libxml_get_errors() as $error) {
                        echo '<pre>' . htmlspecialchars($error->message) . '</pre>';
                    }
                } else {
                    $products = $xml->Product;
                    echo '<h2>Table ' . htmlspecialchars($table_code) . ' Data</h2>';
                    echo '<table border="1">';
                    echo '<tr>';
                    if (!empty($products)) {
                        foreach ($products[0] as $key => $value) {
                            echo '<th>' . htmlspecialchars($key) . '</th>';
                        }
                        echo '</tr>';
                        foreach ($products as $product) {
                            echo '<tr>';
                            foreach ($product as $key => $value) {
                                echo '<td>' . htmlspecialchars($value) . '</td>';
                            }
                            echo '</tr>';
                        }
                    } else {
                        echo '<td colspan="100%">No data found</td>';
                    }
                    echo '</table>';
                }

            } catch (SoapFault $fault) {
                echo '<h2>Error for table ' . htmlspecialchars($table_code) . '</h2>';
                echo '<pre>' . htmlspecialchars($fault) . '</pre>';
            }
        }
    }
    ?>
</body>
</html>
