<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Farmadati Data Viewer</title>
</head>
<body>
    <h1>Visualizza i dati Farmadati</h1>
    <form action="" method="post">
        <button type="submit" name="fetch_tables">Fetch Tables</button>
    </form>

    <?php
    if (isset($_POST['fetch_tables'])) {
        $username = 'BDF20867412';
        $password = 'jwAD4gey7';
        $wsdl = 'https://webservices.farmadati.it/WS2S/FarmadatiItaliaWebServicesM1.svc?singleWsdl';

        try {
            $client = new SoapClient($wsdl, array('trace' => 1));
            $params = array(
                'Username' => $username,
                'Password' => $password
            );
            $response = $client->__soapCall('GetEnabledDataSet', array('parameters' => $params));

            $dataSet = $response->GetEnabledDataSetResult->SetDatiAbilitati->SetDati;

            echo '<h2>Tabella Abilitate</h2>';
            echo '<table border="1">';
            echo '<tr><th>Key</th><th>Description</th><th>Action</th></tr>';

            foreach ($dataSet as $table) {
                echo '<tr>';
                echo '<td>' . htmlspecialchars($table->Key) . '</td>';
                echo '<td>' . htmlspecialchars($table->Description) . '</td>';
                echo '<td>
                    <form action="" method="post">
                        <input type="hidden" name="table_code" value="' . htmlspecialchars($table->Key) . '">
                        <button type="submit" name="fetch_data">Fetch Data</button>
                    </form>
                </td>';
                echo '</tr>';
            }
            echo '</table>';

        } catch (SoapFault $fault) {
            echo '<h2>Error:</h2>';
            echo '<pre>' . htmlspecialchars($fault) . '</pre>';
        }
    }

    if (isset($_POST['fetch_data'])) {
        $username = 'BDF20867412';
        $password = 'jwAD4gey7';
        $wsdl = 'https://webservices.farmadati.it/WS2S/FarmadatiItaliaWebServicesM1.svc?singleWsdl';
        $table_code = $_POST['table_code'];

        try {
            $client = new SoapClient($wsdl, array('trace' => 1));
            $params = array(
                'Username' => $username,
                'Password' => $password,
                'CodiceSetDati' => htmlspecialchars($table_code),
                'CampiDaEstrarre' => array('string' => 'ALL'),
                'Filtri' => null,
                'Ordinamento' => null,
                'Distinct' => false,
                'Count' => false,
                'PageN' => 1,
                'PagingN' => 100
            );
            $response = $client->__soapCall('ExecuteQuery', array('parameters' => $params));

            $outputValue = $response->ExecuteQueryResult->OutputValue;
            $xml = simplexml_load_string($outputValue);
            if ($xml === false) {
                echo '<h2>Error parsing XML</h2>';
                foreach (libxml_get_errors() as $error) {
                    echo '<pre>' . htmlspecialchars($error->message) . '</pre>';
                }
            } else {
                $products = $xml->Product;
                echo '<h2>Risultati della Tabella</h2>';
                echo '<table border="1">';
                echo '<tr>';
                if (!empty($products)) {
                    foreach ($products[0] as $key => $value) {
                        echo '<th>' . htmlspecialchars($key) . '</th>';
                    }
                    echo '</tr>';
                    foreach ($products as $product) {
                        echo '<tr>';
                        foreach ($product as $key => $value) {
                            echo '<td>' . htmlspecialchars($value) . '</td>';
                        }
                        echo '</tr>';
                    }
                } else {
                    echo '<td colspan="100%">No data found</td>';
                }
                echo '</table>';
            }

        } catch (SoapFault $fault) {
            echo '<h2>Error:</h2>';
            echo '<pre>' . htmlspecialchars($fault) . '</pre>';
        }
    }
    ?>
</body>
</html>
