<?php
// Display all errors for debugging purposes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection details
$host = 'localhost';
$dbname = 'enfasi_farmajoin';
$username = 'enfasi_farmajoin';
$password = 'farmajoin105';
$csv_dir = __DIR__ . '/scaricati/';

// Start the import process
echo "\033[34mStarting CSV to MySQL import process...\033[0m\n";

// Establish a database connection
$conn = mysqli_connect($host, $username, $password, $dbname);

// Set the character set to UTF8MB4 to support all characters
mysqli_set_charset($conn, 'utf8mb4');

// Check connection
if (!$conn) {
    die("\033[31mDatabase connection error: " . mysqli_connect_error() . "\033[0m\n");
}

echo "\033[32mDatabase connection successful.\033[0m\n";

// Function to truncate all tables in the database
function truncateAllTables($conn, $dbname) {
    $query = "SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema = '$dbname'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("\033[31mError fetching tables: " . mysqli_error($conn) . "\033[0m\n");
    }

    while ($row = mysqli_fetch_assoc($result)) {
        $tableName = $row['TABLE_NAME'];
        $truncateQuery = "TRUNCATE TABLE `$tableName`";
        if (!mysqli_query($conn, $truncateQuery)) {
            echo "\033[31mError truncating table $tableName: " . mysqli_error($conn) . "\033[0m\n";
        } else {
            echo "\033[32mTable $tableName truncated successfully.\033[0m\n";
        }
    }
}

// Truncate all tables before importing new data
truncateAllTables($conn, $dbname);

// Function to get CSV files from the specified directory
function getCSVFiles($dir) {
    $csvFiles = [];
    foreach (scandir($dir) as $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) === 'csv') {
            $csvFiles[] = $file;
        }
    }
    return $csvFiles;
}

// Retrieve CSV files
$csvFiles = getCSVFiles($csv_dir);
$totalFiles = count($csvFiles);
echo "\033[34mFound $totalFiles CSV files to import.\033[0m\n";

$totalStartTime = microtime(true);

foreach ($csvFiles as $index => $csvFile) {
    $startTime = microtime(true);
    $csvPath = $csv_dir . $csvFile;
    echo "\033[36mProcessing file " . ($index + 1) . " of $totalFiles: $csvFile\033[0m\n";

    // Open the CSV file
    $file = fopen($csvPath, 'r');
    if ($file === false) {
        echo "\033[31mError opening file: $csvFile\033[0m\n";
        continue;
    }

    // Get headers from CSV
    $headers = fgetcsv($file, 0, ','); // Ensure comma as delimiter

    if ($headers === false) {
        echo "\033[31mError reading headers from CSV file: $csvFile\033[0m\n";
        fclose($file);
        continue;
    }

    // Ensure headers are valid MySQL column names
    $headers = array_map(function($header) {
        return preg_replace('/[^a-zA-Z0-9_]/', '_', $header); // Replace invalid characters with underscores
    }, $headers);

    // Create table
    $tableName = pathinfo($csvFile, PATHINFO_FILENAME);
    echo "\033[35mCreating table: $tableName\033[0m\n";

    // Drop the table if it already exists to handle changing CSV structures
    $dropTableQuery = "DROP TABLE IF EXISTS `$tableName`";
    if (!mysqli_query($conn, $dropTableQuery)) {
        echo "\033[31mError dropping existing table: " . mysqli_error($conn) . "\033[0m\n";
        fclose($file);
        continue;
    }

    // Create a new table with the headers
    $createTableQuery = "CREATE TABLE `$tableName` (";
    foreach ($headers as $header) {
        $createTableQuery .= "`" . mysqli_real_escape_string($conn, $header) . "` TEXT, ";
    }
    $createTableQuery = rtrim($createTableQuery, ', ') . ') ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;';

    if (!mysqli_query($conn, $createTableQuery)) {
        echo "\033[31mError creating table: " . mysqli_error($conn) . "\033[0m\n";
        fclose($file);
        continue;
    }

    echo "\033[32mTable created successfully.\033[0m\n";

    // Import data
    echo "\033[35mImporting data...\033[0m\n";
    $rowCount = 0;
    $batchSize = 1000; // Number of rows to insert per batch
    $batchData = [];

    while (($data = fgetcsv($file, 0, ',')) !== FALSE) {
        // Ensure data matches header count
        if (count($data) != count($headers)) {
            echo "\033[31mMismatch between header count and row data count. Skipping row.\033[0m\n";
            continue;
        }

        // Ensure that the data is properly escaped for SQL
        $escapedData = array_map(function($value) use ($conn) {
            return "'" . mysqli_real_escape_string($conn, $value) . "'";
        }, $data);

        $batchData[] = '(' . implode(', ', $escapedData) . ')';

        // Insert batch if it reaches batch size or end of file
        if (count($batchData) >= $batchSize || feof($file)) {
            $insertQuery = "INSERT INTO `$tableName` (`" . implode('`, `', $headers) . "`) VALUES " . implode(', ', $batchData);

            if (!mysqli_query($conn, $insertQuery)) {
                echo "\033[31mError importing batch: " . mysqli_error($conn) . "\033[0m\n";
            } else {
                $rowCount += count($batchData);
                echo "\033[33mImported $rowCount rows...\033[0m\n";
            }

            $batchData = []; // Reset batch
        }
    }

    fclose($file);

    $endTime = microtime(true);
    $elapsedTime = round($endTime - $startTime, 2);
    echo "\033[32mData imported successfully in $elapsedTime seconds.\033[0m\n";
    echo "\033[33mImported $rowCount rows into $tableName.\033[0m\n";
    echo "\n";
}

mysqli_close($conn);

$totalEndTime = microtime(true);
$totalElapsedTime = round($totalEndTime - $totalStartTime, 2);
echo "\033[34mTotal import process completed in $totalElapsedTime seconds.\033[0m\n";

// Memory usage
$memoryUsage = memory_get_peak_usage(true);
echo "\033[35mPeak memory usage: " . round($memoryUsage / 1024 / 1024, 2) . " MB\033[0m\n";

echo "\033[32mImport process finished.\033[0m\n";
