<?php
// Display all errors for debugging purposes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection details
$host = 'localhost';
$dbname = 'enfasi_farmajoin';
$username = 'enfasi_farmajoin';
$password = 'farmajoin105';
$csv_dir = __DIR__ . '/scaricati/';

// Start the import process
echo "\033[34mStarting CSV to MySQL import process...\033[0m\n";

// Establish a database connection
$conn = mysqli_connect($host, $username, $password, $dbname);

// Check connection
if (!$conn) {
    die("\033[31mDatabase connection error: " . mysqli_connect_error() . "\033[0m\n");
}

echo "\033[32mDatabase connection successful.\033[0m\n";

// Function to truncate all tables in the database
function truncateAllTables($conn, $dbname) {
    $query = "SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema = '$dbname'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("\033[31mError fetching tables: " . mysqli_error($conn) . "\033[0m\n");
    }

    while ($row = mysqli_fetch_assoc($result)) {
        $tableName = $row['TABLE_NAME'];
        $truncateQuery = "TRUNCATE TABLE `$tableName`";
        if (!mysqli_query($conn, $truncateQuery)) {
            echo "\033[31mError truncating table $tableName: " . mysqli_error($conn) . "\033[0m\n";
        } else {
            echo "\033[32mTable $tableName truncated successfully.\033[0m\n";
        }
    }
}

// Truncate all tables before importing new data
truncateAllTables($conn, $dbname);

// Function to get CSV files from the specified directory
function getCSVFiles($dir) {
    $csvFiles = [];
    foreach (scandir($dir) as $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) === 'csv') {
            $csvFiles[] = $file;
        }
    }
    return $csvFiles;
}

// Retrieve CSV files
$csvFiles = getCSVFiles($csv_dir);
$totalFiles = count($csvFiles);
echo "\033[34mFound $totalFiles CSV files to import.\033[0m\n";

$totalStartTime = microtime(true);

foreach ($csvFiles as $index => $csvFile) {
    $startTime = microtime(true);
    $csvPath = $csv_dir . $csvFile;
    echo "\033[36mProcessing file " . ($index + 1) . " of $totalFiles: $csvFile\033[0m\n";

    // Open the CSV file
    $file = fopen($csvPath, 'r');
    if ($file === false) {
        echo "\033[31mError opening file: $csvFile\033[0m\n";
        continue;
    }

    // Check if file is empty
    $firstChar = fgetc($file);
    if ($firstChar === false) {
        echo "\033[31mCSV file is empty: $csvFile\033[0m\n";
        fclose($file);
        continue;
    }
    rewind($file); // Reset pointer to start of the file

    // Get headers from CSV
    $headers = fgetcsv($file, 0, ','); // Ensure comma as delimiter

    if ($headers === false) {
        echo "\033[31mError reading headers from CSV file: $csvFile\033[0m\n";
        fclose($file);
        continue;
    }

    // Normalize headers
    $headers = array_map(function($header) {
        return preg_replace('/[^\w]+/', '_', $header); // Normalize to valid SQL column names
    }, $headers);

    // Validate headers
    if (empty($headers)) {
        echo "\033[31mNo valid headers found in CSV file: $csvFile\033[0m\n";
        fclose($file);
        continue;
    }

    // Create table
    $tableName = pathinfo($csvFile, PATHINFO_FILENAME);
    echo "\033[35mCreating table: $tableName\033[0m\n";

    // Drop the table if it already exists to handle changing CSV structures
    $dropTableQuery = "DROP TABLE IF EXISTS `$tableName`";
    if (!mysqli_query($conn, $dropTableQuery)) {
        echo "\033[31mError dropping existing table: " . mysqli_error($conn) . "\033[0m\n";
        fclose($file);
        continue;
    }

    // Create a new table with the headers
    $createTableQuery = "CREATE TABLE `$tableName` (";
    foreach ($headers as $header) {
        $createTableQuery .= "`" . mysqli_real_escape_string($conn, $header) . "` TEXT, ";
    }
    $createTableQuery = rtrim($createTableQuery, ', ') . ') ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;';

    if (!mysqli_query($conn, $createTableQuery)) {
        echo "\033[31mError creating table: " . mysqli_error($conn) . "\033[0m\n";
        fclose($file);
        continue;
    }

    echo "\033[32mTable created successfully.\033[0m\n";

    // Import data
    echo "\033[35mImporting data...\033[0m\n";
    $rowCount = 0;
    $batchSize = 1000; // Number of rows to insert per batch
    $batchData = [];
    $totalRowCount = 0; // Total row count across batches
    $rowNumber = 0;

    while (($data = fgetcsv($file, 0, ',')) !== FALSE) {
        $rowNumber++;
        // Ensure data matches header count
        if (count($data) != count($headers)) {
            echo "\033[31mMismatch between header count and row data count at row $rowNumber. Skipping row.\033[0m\n";
            continue;
        }

        // Remove quotes from data
        $data = array_map(function($value) {
            return str_replace('"', '', $value);
        }, $data);

        $escapedData = array_map(function($value) use ($conn) {
            // Escape all special characters
            return "'" . mysqli_real_escape_string($conn, $value) . "'";
        }, $data);

        $batchData[] = '(' . implode(', ', $escapedData) . ')';

        // Insert batch if it reaches batch size or end of file
        if (count($batchData) >= $batchSize || feof($file)) {
            $insertQuery = "INSERT INTO `$tableName` (`" . implode('`, `', $headers) . "`) VALUES " . implode(', ', $batchData);

            if (!mysqli_query($conn, $insertQuery)) {
                echo "\033[31mError importing batch at row $rowNumber: " . mysqli_error($conn) . "\033[0m\n";
                // Log detailed error
                error_log("SQL Error on batch insert at row $rowNumber in table $tableName: " . mysqli_error($conn));
                $batchData = []; // Reset batch
                continue; // Skip the current batch due to error
            } else {
                $rowCount += count($batchData);
                $totalRowCount += count($batchData);
                if ($totalRowCount % 50000 === 0) {
                    echo "\033[33mImported $totalRowCount rows so far...\033[0m\n";
                }
            }

            $batchData = []; // Reset batch
        }
    }

    fclose($file);

    // Query the row count in the table for verification
    $countQuery = "SELECT COUNT(*) as total_rows FROM `$tableName`";
    $countResult = mysqli_query($conn, $countQuery);
    if ($countResult) {
        $row = mysqli_fetch_assoc($countResult);
        $actualRowCount = $row['total_rows'];
        echo "\033[32mActual imported rows in $tableName: $actualRowCount\033[0m\n";

        // Check for zero records
        if ($actualRowCount === 0) {
            echo "\033[31mNo records were imported for $tableName. Possible reasons could be:\033[0m\n";
            echo "\033[31m- Empty CSV file\033[0m\n";
            echo "\033[31m- Header mismatch or incorrect header format\033[0m\n";
            echo "\033[31m- Data type or formatting issues\033[0m\n";
            echo "\033[31m- Special characters causing insert failure\033[0m\n";
            echo "\033[31m- Incorrect encoding, try checking the file's character set.\033[0m\n";
            // Debugging: check the actual contents
            echo "\033[31mAttempt to view some rows in CSV for debugging:\033[0m\n";
            // Reopen the file to check the first few lines
            $fileCheck = fopen($csvPath, 'r');
            if ($fileCheck !== false) {
                $headerLine = fgetcsv($fileCheck, 0, ',');
                echo "\033[31mHeaders: " . implode(", ", $headerLine) . "\033[0m\n";
                for ($i = 0; $i < 5 && !feof($fileCheck); $i++) {
                    $dataLine = fgetcsv($fileCheck, 0, ',');
                    if ($dataLine !== false) {
                        echo "\033[31mLine $i: " . implode(", ", $dataLine) . "\033[0m\n";
                    }
                }
                fclose($fileCheck);
            }
        }
    } else {
        echo "\033[31mError verifying row count for $tableName: " . mysqli_error($conn) . "\033[0m\n";
    }

    $endTime = microtime(true);
    $elapsedTime = round($endTime - $startTime, 2);
    echo "\033[32mData import for $tableName completed in $elapsedTime seconds.\033[0m\n";
    echo "\n";
}

mysqli_close($conn);

$totalEndTime = microtime(true);
$totalElapsedTime = round($totalEndTime - $totalStartTime, 2);
echo "\033[34mTotal import process completed in $totalElapsedTime seconds.\033[0m\n";

// Memory usage
$memoryUsage = memory_get_peak_usage(true);
echo "\033[35mPeak memory usage: " . round($memoryUsage / 1024 / 1024, 2) . " MB\033[0m\n";

echo "\033[32mImport process finished.\033[0m\n";
?>
