<?php
$output_dir = __DIR__ . '/scaricati/';
// Ensure the output directory exists
if (!file_exists($output_dir)) {
    mkdir($output_dir, 0777, true);
}

// List of tables
$tables = ['TE002', 'TE004', 'TE018', 'TR039', 'TR048', 'TR011', 'TR036', 'TR037', 'TS010', 'TS011', 'TS042', 'TS043', 'TS054', 'TS077'];

// SOAP action and endpoint
$soapAction = "https://webservices.farmadati.it/FarmadatiItaliaWebServicesM2/GetDataSet";
$endpoint = "https://webservices.farmadati.it/WS2S/FarmadatiItaliaWebServicesM2.svc";

// Function to download and save a single table as ZIP
function downloadAndSaveTableZip($tableCode, $output_dir, $soapAction, $endpoint) {
    // SOAP request XML
    $requestXml = <<<XML
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:web="https://webservices.farmadati.it">
    <soapenv:Header/>
    <soapenv:Body>
        <web:GetDataSet>
            <web:Username>BDF20867412</web:Username>
            <web:Password>jwAD4gey7</web:Password>
            <web:CodiceSetDati>{$tableCode}</web:CodiceSetDati>
            <web:Modalita>GETRECORDS</web:Modalita>
            <web:PageN>1</web:PageN>
        </web:GetDataSet>
    </soapenv:Body>
</soapenv:Envelope>
XML;

    // Initialize cURL
    $ch = curl_init($endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: text/xml; charset=utf-8',
        'SOAPAction: ' . $soapAction
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $requestXml);

    // Execute the request
    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false) {
        die('Error occurred while making the request.');
    }

    // Parse the response to extract the base64 encoded zip file
    $doc = new DOMDocument();
    $doc->loadXML($response);
    $xpath = new DOMXPath($doc);
    $xpath->registerNamespace('s', 'http://schemas.xmlsoap.org/soap/envelope/');
    $xpath->registerNamespace('a', 'http://schemas.datacontract.org/2004/07/FDIWebServices');
    $base64EncodedZip = $xpath->evaluate('string(//a:ByteListFile)');

    if (empty($base64EncodedZip)) {
        die('Error: Failed to retrieve the file content from the response.');
    }

    // Decode the base64 content
    $zipContent = base64_decode($base64EncodedZip);
    if ($zipContent === false) {
        die('Error: Failed to decode the base64 content.');
    }

    // Save the ZIP file
    $zipFilePath = $output_dir . $tableCode . '.zip';
    if (file_put_contents($zipFilePath, $zipContent)) {
        echo "ZIP file saved: $zipFilePath\n";
    } else {
        echo "Error: Failed to save ZIP file for table $tableCode\n";
    }
}

// Loop through each table and process
foreach ($tables as $tableCode) {
    downloadAndSaveTableZip($tableCode, $output_dir, $soapAction, $endpoint);
}