<?php
include 'config.php';

function fetch_table_data($table_code, $username, $password, $wsdl, $page, $records_per_page) {
    try {
        $client = new SoapClient($wsdl, array('trace' => 1));
        $params = array(
            'Username' => $username,
            'Password' => $password,
            'CodiceSetDati' => $table_code,
            'CampiDaEstrarre' => array('string' => 'ALL'),
            'Filtri' => null,
            'Ordinamento' => null,
            'Distinct' => false,
            'Count' => false,
            'PageN' => $page,
            'PagingN' => $records_per_page
        );
        $response = $client->__soapCall('ExecuteQuery', array('parameters' => $params));
        $outputValue = $response->ExecuteQueryResult->OutputValue;
        $xml = simplexml_load_string($outputValue);
        if ($xml === false) {
            return [];
        } else {
            return $xml->Product;
        }
    } catch (SoapFault $fault) {
        return [];
    }
}
?>
